C SPARSE-	START OF PARSE
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
C THIS ROUTINE DETAILS ON BIT 2 OF PRSFLG
C
	INTEGER FUNCTION SPARSE(LBUF,LLNT,VBFLAG)
	IMPLICIT INTEGER(A-Z)
	INTEGER LBUF(40)
	LOGICAL LIT,QHERE,OTEST,DFLAG,VBFLAG
C
C PARSER OUTPUT
C
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C PARSER STATE
C
	COMMON /ORPHS/ OFLAG,OACT,OSLOT,OPREP,ONAME
	COMMON /LAST/ LASTIT
	COMMON /PV/ ACT,O1,O2,P1,P2
	INTEGER OBJVEC(2),PRPVEC(2)
	EQUIVALENCE (OBJVEC(1),O1),(PRPVEC(1),P1)
C
C GAME STATE
C
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /DEBUG/ DBGFLG,PRSFLG
C
C OBJECTS
C
	COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
	1	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
	2	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
	3	OADV(220),OCAN(220),OREAD(220)
C
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ WARNI,CSLIT,GCARD,STLDR
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
C
C ADVENTURERS
C
	COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
	1	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C VERBS
C
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
C SPARSE, PAGE 2
C
C VOCABULARIES
C
	COMMON /BUZVOC/ BVOC(20)
	COMMON /PRPVOC/ PVOC(45)
	COMMON /DIRVOC/ DVOC(75)
	INTEGER AVOC(450)
	COMMON /ADJVOC/ AVOC1(184),AVOC2(114),AVOC3(106),AVOCND
	INTEGER VVOC(950)
	COMMON /VRBVOC/ VVOC1(92),VVOC1A(108),VVOC1B(38),VVOC2(104),
	1	VVOC3(136),
	2	VVOC4(116),VVOC5(134),VVOC6(117),VVOC7(89),VVOCND
	INTEGER OVOC(1050)
	COMMON /OBJVOC/ OVOC1(159),OVOC2(144),OVOC3(150),OVOC4(128),
	1	OVOC5(111),OVOC6(104),OVOC6A(97),OVOC7(127),OVOCND
C
	EQUIVALENCE (VVOC(1),VVOC1(1))
	EQUIVALENCE (AVOC(1),AVOC1(1))
	EQUIVALENCE (OVOC(1),OVOC1(1))
C
C FUNCTIONS AND DATA
C
	OTEST(R)=(R.GT.0).AND.(R.LT.R50MIN)
	DATA R50MIN/1RA/,R50WAL/3RWAL/
C
C BUZZ WORDS--	IGNORED IN SYNTACTIC PROCESSING
C
	DATA BVOC/3RAND,0,2RBY,0,2RIS,0,1RA,0,
	1	2RAN,0,3RTHE,0,3RRUN,0,2RGO,0,3RPRO,3RCEE,0,0/
C
C PREPOSITIONS--	MAPS PREPOSITIONS TO INDICES
C
	DATA PVOC/3ROVE,1RR,1,3RWIT,1RH,2,3RUSI,2RNG,2,3RTHR,3ROUG,2,
	1	2RAT,0,3,2RTO,0,4,2RIN,0,5,3RINS,3RIDE,5,3RINT,1RO,5,
	2	3RDOW,1RN,6,2RUP,0,7,3RUND,2RER,8,2ROF,0,9,2RON,0,10,
	3	3ROFF,0,11/
C
C DIRECTIONS--	MAPS DIRECTIONS TO INDICES
C
	DATA DVOC/1RN,0,"2000,3RNOR,2RTH,"2000,1RS,0,"12000,
	1 1RE,0,"6000,3REAS,1RT,"6000,1RW,0,"16000,3RWES,1RT,"16000,
	2 2RSE,0,"10000,2RSW,0,"14000,
	3 2RNE,0,"4000,2RNW,0,"20000,
	4 1RU,0,"22000,2RUP,0,"22000,1RD,0,"24000,3RDOW,1RN,"24000,
	5 3RLAU,3RNCH,"26000,3RLAN,1RD,"30000,3RENT,2RER,"32000,
	6 3REXI,1RT,"34000,3ROUT,0,"34000,3RLEA,2RVE,"34000,
	7 3RTRA,3RVEL,"36000,3RSOU,2RTH,"12000,
	8 2RIN,0,"32000,
	9 3RCRO,2RSS,"36000/
C SPARSE, PAGE 3
C
C ADJECTIVES--	MAPS ADJECTIVES TO OBJECT NUMBERS
C
C EACH ENTRY IS VARIABLE LENGTH AND CONSISTS OF A TWO WORD
C ADJECTIVE IN RADIX-50 FOLLOWED BY ONE OR MORE OBJECT NUMBERS.
C NOTE THAT ADJECTIVES CAN BE DISTINGUISHED FROM OBJECTS AS
C FOLLOWS-- ALL ADJECTIVES ARE .GE. 1RA (1600), WHILE ALL OBJECTS
C ARE .LE. OLNT (255 MAX).
C
	DATA AVOC1/3RBRO,2RWN,1,81,3RELO,3RNGA,1,3RHOT,0,3,3RPEP,3RPER,3,
	1 3RVIT,3RREO,4,3RJAD,1RE,6,3RHUG,1RE,8,3RENO,3RRMO,8,122,
	2 3RTRO,3RPHY,9,3RCLE,2RAR,10,3RLAR,2RGE,12,26,47,95,96,123,
	2 133,135,146,147,150,176,3RNAS,2RTY,13,3RELV,3RISH,14,
	2 3RBRA,2RSS,15,16,46,156,
	3 3RBRO,3RKEN,16,22,92,113,155,158,3RORI,3RENT,17,
	4 3RBLO,3RODY,20,3RRUS,2RTY,21,3RBUR,3RNED,22,
	5 3RDEA,1RD,22,3ROLD,0,25,41,44,45,3RLEA,3RTHE,25,
	5 3RPLA,3RTIN,26,3RPEA,2RRL,27,
	6 3RMOB,1RY,31,3RCRY,3RSTA,32,126,
	6 3RGOL,1RD,33,85,104,157,158,188,
	7 3RIVO,2RRY,34,3RSAP,3RPHI,37,3RWOO,3RDEN,38,67,136,137,
	7 165,173,174,175,3RWOO,1RD,38,67,136,137,165,173,174,175,
	7 3RSTE,2REL,39,125,189,
	8 3RDEN,3RTED,39,3RFAN,2RCY,40,3RANC,3RIEN,41,44,
	9 3RSMA,2RLL,5,46,52,53,89,102,103,153,187,
	1 3RBLA,2RCK,47,162,3RTOU,1RR,49,
	2 3RVIS,3RCOU,55,3RVIC,3RIOU,62,
	3 3RGLA,2RSS,10,126,132,3RTRA,1RP,66/
C
	DATA AVOC2/3RFRO,2RNT,68,3RSTO,2RNE,69,150,214,3RMAN,3RGLE,72,
	1 3RRED,0,79,94,140,161,170,171,3RYEL,3RLOW,80,159,
	1 3RBLU,1RE,82,112,114,141,
	2 3RVAM,3RPIR,83,3RMAG,2RIC,90,
	3 3RSEA,3RWOR,90,3RTAN,0,91,3RSHA,2RRP,92,
	4 3RWIC,3RKER,98,3RCLO,2RTH,100,
	5 3RBRA,3RIDE,101,
	6 3RGAU,2RDY,108,3RSQU,3RARE,109,127,3RCLA,1RY,109,
	7 3RSHI,2RNY,110,3RTHI,1RN,110,
	8 3RGRE,2REN,115,143,3RPUR,3RPLE,116,3RWHI,2RTE,117,147,160,
	9 3RMAR,3RBLE,119,3RCOK,1RE,121,3REMP,2RTY,121,
	1 3RROU,2RND,128,3RTRI,3RANG,129,
 	2 3RRAR,1RE,134,3ROBL,3RONG,135,3REAT,3R$ME,138,
	3 3REAT,2RME,138,3RORA,3RNGE,139,3RECC,1RH,141/
C
	DATA AVOC3/3RROC,2RKY,147,3RSHE,2RER,147,
	1 3R200,0,148,3RNEA,1RT,148,3RSHI,3RMME,151,
	2 3RZUR,3RICH,152,3RBIR,2RDS,153,154,155,
	3 3RENC,3RRUS,154,155,3RBEA,3RUTI,156,3RCLO,3RCKW,157,158,
	4 3RMEC,3RHAN,157,158,
	5 3RMAH,3ROGA,163,3RPIN,1RE,164,3RLON,1RG,166,
	6 3RCEN,3RTER,166,3RSHO,2RRT,167,1RT,0,168,
	7 3RCOM,3RPAS,169,211,3RBRO,3RNZE,172,3RCEL,1RL,174,175,
	8 3RLOC,3RKED,174,3RSUN,0,177,
	8 3RBAR,1RE,200,3RSON,1RG,203,
	5 3RNOR,2RTH,205,3RNOR,3RTHE,205,3RSOU,2RTH,206,
	6 3RSOU,3RTHE,206,3REAS,1RT,207,3REAS,3RTER,207,
	7 3RWES,1RT,208,3RWES,3RTER,208,3RDUN,3RGEO,215/
C
	DATA AVOCND/-1/
C SPARSE, PAGE 4
C
C VERBS--	MAPS VERBS TO SYNTAX SLOTS
C
C EACH ENTRY IS VARIABLE LENGTH AND CONSISTS OF ONE OR MORE
C TWO WORD VERBS IN RADIX-50 FOLLOWED BY A SYNTAX WORD COUNT
C FOLLOWED BY ONE OR MORE SYNTAXES.  NOTE THAT VERBS CAN BE
C DISTINGUISHED FROM WORD COUNTS AS FOLLOWS--
C ALL VERBS ARE .GE. 1RA (1600), WHILE ALL SYNTAX WORD COUNTS
C ARE .LE. 255.
C
C SYNTAX ENTRIES CONSIST OF A FLAG WORD FOLLOWED BY 0, 1, OR 2
C OBJECT DESCRIPTIONS.  THE FLAG WORD HAS THE FOLLOWING FORMAT--
C
C BIT <14>	IF 1, SYNTAX INCLUDES DIRECT OBJECT
C BIT <13>	IF 1, SYNTAX INCLUDES INDIRECT OBJECT
C BIT <12>	IF 1, DIRECT OBJECT IS IMPLICIT (STANDARD FORM)
C BIT <11>	IF 1, DIRECT AND INDIRECT OBJECT MUST BE SWAPPED
C			AFTER SYNTAX PROCESSING
C BIT <10>	IF 1, THIS IS DEFAULT SYNTAX FOR ORPHANERY
C BITS <8:0>	VERB NUMBER FOR VAPPLI
C
C OBJECT DESCRIPTIONS CONSIST OF A FLAG WORD AND TWO FWIM WORDS.
C THE FLAG WORD HAS THE FOLLOWING FORMAT--
C
C BIT <14>	IF 1, SEARCH ADVENTURER FOR OBJECT
C BIT <13>	IF 1, SEARCH ROOM FOR OBJECT
C BIT <12>	IF 1, PARSER WILL TRY TO TAKE OBJECT
C BIT <11>	IF 1, ADVENTURER MUST HAVE OBJECT
C BIT <10>	IF 1, QUALIFYING BITS (NORMALLY -1,-1) ARE SAME
C			AS FWIM BITS
C BIT <9>	IF 1, OBJECT MUST BE REACHABLE
C BITS <8:0>	PREPOSITION NUMBER FOR SYNMCH
C
C THE FWIM WORDS HAVE THE SAME FORMAT AS THE TWO OBJECT FLAG WORDS.
C
C NOTE THAT BITS 12 AND 11 OF OBJECT DESCRIPTIONS ACTUALLY HAVE
C FOUR DISTINCT STATES--
C
C	BIT 12	BIT 11	MDLDESC		INTERPRETATION
C	------	------	-------		---------------
C
C	  0	  0	 --		NO PARSER ACTION
C	  0	  1	 HAVE		ADVENTURER MUST HAVE OBJECT
C	  1	  0	 TRY		TRY TO TAKE, DONT CARE IF FAIL
C	  1	  1	 TAKE		TRY TO TAKE, CARE IF FAIL
C
C SPARSE, PAGE 5
C
	DATA VVOC1/3RBRI,2REF,1,70,3RVER,3RBOS,1,71,
	1 3RSUP,3RERB,1,72,3RSTA,1RY,1,73,3RVER,3RSIO,1,74,
	2 3RSWI,1RM,3RBAT,2RHE,3RWAD,1RE,1,75,3RGER,3RONI,1,76,
	2 3RULY,3RSSE,3RODY,3RSSE,1,77,
	3 3RWEL,1RL,1,78,3RPRA,1RY,1,79,3RTRE,3RASU,1,80,
	4 3RTEM,3RPLE,1,81,3RBLA,2RST,1,82,3RSCO,2RRE,1,83,
	5 1RQ,0,3RQUI,1RT,1,84,3RHEL,1RP,1,40,3RINF,1RO,1,41,
	6 3RHIS,3RTOR,3RUPD,3RATE,1,42,3RBAC,1RK,1,43,
	6 3RSIG,1RH,3RMUM,3RBLE,1,44/
C
	DATA VVOC1A/3RCHO,2RMP,3RLOS,1RE,3RBAR,1RF,1,45,
	7 3RDUN,3RGEO,1,46,3RFRO,3RBOZ,1,47,3RFOO,0,3RBLE,3RTCH,
	8 3RBAR,0,1,48,3RREP,3RENT,1,49,3RHOU,1RS,3RSCH,3REDU,1,50,
	9 3RWIN,0,1,51,3RYEL,1RL,3RSCR,3REAM,3RSHO,2RUT,1,52,
	9 3RHOP,0,3RSKI,1RP,1,53,3RFUC,1RK,3RSHI,1RT,3RDAM,1RN,
	1 3RCUR,2RSE,1,54,3RZOR,1RK,1,55,3RGRA,3RNIT,1,"50070,
	2 3RSAV,1RE,1,149,3RRES,3RTOR,1,150,3RTIM,1RE,1,90,
	3 3RDIA,3RGNO,1,94,3REXO,3RRCI,1,105,3RINV,3RENT,
	4 1RI,0,1,133,3RWAI,1RT,1,128,
	5 3RINC,3RANT,1,95,3RANS,3RWER,1,96/
C
	DATA VVOC1B/3RAGA,2RIN,1,57,3RNOO,2RBJ,1,58,
	1 3RBUG,0,3RGRI,2RPE,3RCOM,3RPLA,1,59,
	2 3RFEA,3RTUR,3RCOM,3RMEN,3RSUG,3RGES,3RIDE,1RA,1,60,
	3 3RROO,1RM,1,65,3ROBJ,3RECT,1,66,3RRNA,2RME,1,67/
C
	DATA VVOC2/3RDEF,3RLAT,1,"50147,
	1 3RDES,3RCRI,3RWHA,1RT,3REXA,3RMIN,1,"50170,
	1 3RFIL,1RL,11,"60206,"61000,"200,0,"61002,"400,0,
	1	"40206,"61000,"200,0,
	1 3RFIN,1RD,3RSEE,1RK,3RWHE,2RRE,3RSEE,0,4,"40177,"60000,-1,-1,
	1 3RFOL,3RLOW,2,"125,"50125,
	2 3RKIC,1RK,3RBIT,1RE,3RTAU,2RNT,1,"50153,3RLOW,2RER,1,"50156,
	3 3RPUS,1RH,3RPRE,2RSS,1,"50160,3RRIN,1RG,3RPEA,1RL,1,"50127,
	4 3RRUB,0,3RCAR,3RESS,3RTOU,2RCH,3RFON,3RDLE,1,"50157,
	4 3RSHA,2RKE,1,"50171,3RSPI,1RN,1,"50201,
	5 3RUNT,2RIE,3RFRE,1RE,1,"50161,3RWAL,1RK,9,"50216,
	5	"40126,"61002,-1,-1,"40126,"61005,-1,-1/
C
	DATA VVOC3/3RATT,3RACK,3RFIG,2RHT,3RINJ,3RURE,3RHIT,0,3RHUR,1RT,
	1	7,"60215,"21000,0,"200,"44002,0,"1000,
	2 3RBOA,2RRD,4,"40202,"21000,0,"2,
	3 3RBRU,2RSH,3RCLE,2RAN,5,"52130,"70130,"61002,-1,-1,
	4 3RBUR,1RN,3RIGN,3RITE,3RINC,3RINE,7,"60211,"61000,"20,0,
	5	"64002,"10,0,
	6 3RCLI,2RMB,12,"40235,"20007,0,"4000,
	6	"40236,"20006,0,"4000,"40234,"20000,0,"4000,
	6 3RCLO,2RSE,4,"40176,"61000,"10200,0,
	7 3RDIG,0,4,"40131,"44002,"4,0,
	8 3RDIS,3REMB,4,"40203,"20000,0,"2,
	9 3RDRI,2RNK,3RIMB,3RIBE,3RSWA,3RLLO,4,"40210,"61000,"400,0,
	1 3RDRO,1RP,3RREL,3REAS,11,"42221,"41000,-1,-1,
	2	"60221,"41000,-1,-1,"61005,-1,-1,
	3 3REAT,0,3RCON,3RSUM,3RGOB,3RBLE,3RMUN,2RCH,3RTAS,2RTE,
	3	4,"40207,"75000,"2000,0,
	4 3REXT,3RING,3RDOU,2RSE,4,"40174,"75000,"100,0/
C
	DATA VVOC4/3RGIV,1RE,3RHAN,1RD,3RDON,3RATE,11,"72222,"21004,
	1	"40,0,"64222,"21000,"40,0,"61000,-1,-1,
	2 3RHEL,2RLO,2RHI,0,2,"2227,"50227,
	3 3RBLO,1RW,15,"62146,"61007,-1,-1,"61002,"4,0,
	4	"40160,"61007,-1,-1,"40165,"61005,-1,-1,
	5 3RINF,3RLAT,4,"70146,"61002,"4,0,
	6 3RJUM,1RP,3RLEA,1RP,5,"133,"40133,"61001,-1,-1,
	7 3RKIL,1RL,3RMUR,3RDER,3RSLA,1RY,3RSTA,1RB,3RDIS,3RPAT,
	7	7,"60213,"21000,0,"200,
	8	"44002,0,"1000,
	9 3RKNO,2RCK,3RRAP,0,12,"42166,"61003,-1,-1,
	1	"40166,"61012,-1,-1,"40215,"23006,"40,0,
	2 3RLIG,2RHT,11,"42173,"75000,"100,0,
	3	"60211,"61000,"100,0,"54002,"10,0,
	4 3RLOC,1RK,4,"40134,"20000,-1,-1/
C
	DATA VVOC5/3RLOO,1RK,1RL,0,3RSTA,2RRE,3RGAZ,1RE,
	1	13,"167,"40167,"60003,-1,-1,
	1	"40231,"61010,-1,-1,"40230,"60005,-1,-1,
	2 3RMEL,1RT,3RLIQ,3RUIF,4,"70145,"61002,"10,0,
	3 3RMOV,1RE,4,"40172,"20000,-1,-1,
	4 3RPUL,1RL,3RTUG,0,8,"42172,"21000,-1,-1,
	5	"40172,"21012,-1,-1,
	6 3RMUN,1RG,3RHAC,1RK,3RFRO,1RB,3RDAM,3RAGE,
	6	5,"52212,"70212,"44002,-1,-1,
	7 3ROPE,1RN,11,"42175,"61000,"10200,0,
	7	"60175,"61000,"10200,0,"54002,"4,"1000,
	8 3RPIC,1RK,4,"40204,"61007,"20000,"40,
	9 3RPLU,1RG,3RGLU,1RE,3RPAT,2RCH,4,"70152,"61002,-1,-1,
	1 3RPOK,1RE,3RBRE,2RAK,3RJAB,0,7,"60212,"21000,0,"200,
	2	"44002,0,"1000,
	3 3RPOU,1RR,3RSPI,2RLL,11,"42223,"42000,"400,0,
	4	"60223,"42000,"400,0,"60005,-1,-1,
	5	3RPUM,1RP,4,"60232,"60007,-1,-1/
C
	DATA VVOC6/3RPUT,0,3RINS,3RERT,3RSTU,2RFF,3RPLA,2RCE,
	1	8,"72220,"61005,-1,-1,
	1	"40221,"61006,-1,-1,
	2 3RRAI,2RSE,3RLIF,1RT,5,"52155,"40155,"61007,-1,-1,
	3 3RREA,1RD,3RSKI,1RM,11,"42144,"71000,"40000,0,
	4	"60144,"71000,"40000,0,"61002,-1,-1,
	5 3RSTR,3RIKE,12,"60215,"23000,"40,0,
	6	"44002,0,"1000,"42215,"23000,"40,0,"50173,
	7 3RSWI,2RNG,3RTHR,3RUST,7,"60214,"44000,0,"1000,
	8	"21003,0,"200,
	9 3RTAK,1RE,3RGET,0,3RHOL,1RD,3RCAR,2RRY,3RREM,3ROVE,
	9	4,"40204,"61000,"20000,"40,
	1 3RTEL,1RL,3RCOM,3RMAN,3RREQ,3RUES,4,"40217,"20000,0,"2000,
	2 3RTHR,2ROW,3RHUR,1RL,3RCHU,2RCK,14,"60224,"44000,-1,-1,
	3	"21003,"40,0,"60224,"44000,-1,-1,"21002,"40,0/
C
	DATA VVOC7/3RTIE,0,3RFAS,3RTEN,11,"70162,"61004,-1,-1,
	1	"60163,"21000,"40,0,"65002,"4,0,
	2 3RTUR,1RN,3RSET,0,22,"62164,"61000,"2,0,
	3	"64002,"4,0,
	4	"40173,"75012,"100,0,"40174,"75013,"100,0,
	5	"60237,"61000,"2,0,"20004,-1,-1,
	6 3RUNL,3ROCK,7,"60135,"21000,-1,-1,
	7	"74002,"4,0,
	8 3RWAK,1RE,3RSUR,3RPRI,3RALA,2RRM,3RSTA,3RRTL,
	8	8,"42150,"20000,"40,0,
	9	"40150,"20007,"40,0,
	1 3RWAV,1RE,3RFLA,3RUNT,3RBRA,3RNDI,4,"40154,"40000,-1,-1,
	2 3RWIN,1RD,5,"50233,"40233,"61007,-1,-1/
C
	DATA VVOCND/-1/
C SPARSE, PAGE 6
C
C OBJECTS--	MAPS OBJECTS TO OBJECT INDICES
C
C SAME FORMAT AS AVOC.
C
	DATA OVOC1/3RBAG,0,1,25,100,3RSAC,1RK,1,3RGAR,3RLIC,2,
	1 3RCLO,2RVE,2,3RFOO,1RD,3,3RSAN,3RDWI,3,3RLUN,2RCH,3,
	2 3RDIN,3RNER,3,
	2 3RGUN,1RK,4,55,3RPIE,2RCE,4,143,186,3RSLA,1RG,4,3RCOA,1RL,5,
	3 3RPIL,1RE,5,38,78,87,88,122,3RHEA,1RP,5,
	3 3RFIG,3RURI,6,
	4 3RMAC,3RHIN,7,3RPDP,2R10,7,3RPDP,2R11,7,3RDRY,2RER,7,
	5 3RLID,0,7,3RDIA,3RMON,8,3RCAS,1RE,9,123,3RBOT,3RTLE,10,121,
	6 3RCON,3RTAI,10,3RWAT,2RER,11,209,3RQUA,3RNTI,11,209,
	6 3RLIQ,3RUID,11,209,3RH2O,0,11,209,
	7 3RROP,1RE,12,101,3RHEM,1RP,12,3RCOI,1RL,12,110,
	8 3RKNI,2RFE,13,21,3RBLA,2RDE,13,14,3RSWO,2RRD,14,3RORC,3RHRI,14,
	9 3RGLA,3RMDR,14,3RLAM,1RP,15,16,22,3RLAN,3RTER,15,16,22,
	1 3RRUG,0,17,3RCAR,3RPET,17,
	2 3RLEA,3RVES,18,3RLEA,1RF,18,3RTRO,2RLL,19,
	3 3RAXE,0,20,3RDIN,3RNER,3/
C
	DATA OVOC2/3RKEY,1RS,23,3RKEY,0,23,
	1 3RSET,0,23,3RBON,2RES,24,3RSKE,3RLET,24,3RBOD,1RY,24,73,
	2 3RCOI,2RNS,25,3RBAR,0,26,165,168,
	3 3RNEC,3RKLA,27,3RPEA,3RRLS,27,3RMIR,3RROR,28,29,212,
	4 3RICE,0,30,3RMAS,1RS,30,3RGLA,3RCIE,30,3RRUB,1RY,31,
	5 3RTRI,3RDEN,32,3RFOR,1RK,32,3RCOF,3RFIN,33,3RCAS,3RKET,33,
	6 3RTOR,2RCH,34,3RCAG,1RE,35,36,124,125,3RDUM,3RBWA,35,36,
	7 3RBAS,3RKET,35,36,98,113,3RBRA,3RCEL,37,
	8 3RJEW,2REL,37,3RTIM,3RBER,38,3RBOX,0,39,53,105,3RSTR,3RADI,40,
	9 3RVIO,3RLIN,40,3RENG,3RRAV,41,3RINS,3RCRI,41,44,3RGHO,2RST,42,
	1 3RSPI,3RRIT,42,3RFIE,2RND,42,3RGRA,2RIL,43,3RPRA,3RYER,44,47,
	2 3RTRU,2RNK,45,3RCHE,2RST,45,3RBEL,1RL,46,
	3 3RBOO,1RK,47,49,114,115,116,117,3RBIB,2RLE,47/
C
	DATA OVOC3/3RGOO,3RDBO,47,3RCAN,3RDLE,48,3RPAI,1RR,48,
	1 3RGUI,3RDEB,49,
	1 3RGUI,2RDE,49,3RPAP,2RER,50,122,143,186,3RNEW,3RSPA,50,
	2 3RISS,2RUE,50,3RREP,3RORT,50,3RMAG,3RAZI,50,3RNEW,1RS,50,
	3 3RMAT,3RCHB,51,
	3 3RMAT,2RCH,51,3RMAT,3RCHE,51,3RADV,3RERT,52,3RPAM,3RPHL,52,
	4 3RLEA,3RFLE,52,3RBOO,3RKLE,52,3RMAI,3RLBO,53,
	5 3RTUB,1RE,54,3RTOO,3RTHP,54,3RPUT,2RTY,55,3RMAT,3RERI,55,
	6 3RGLU,1RE,55,3RWRE,3RNCH,56,3RSCR,3REWD,57,
	7 3RCYC,3RLOP,58,3RMON,3RSTE,58,3RCHA,3RLIC,59,3RCUP,0,59,
	8 3RGOB,3RLET,59,3RPAI,3RNTI,60,149,3RART,0,60,149,
	8 3RCAN,3RVAS,60,3RPIC,3RTUR,60,3RWOR,1RK,60,
	9 3RMAS,3RTER,60,215,3RTHI,2REF,61,3RROB,3RBER,61,
	1 3RCRI,3RMIN,61,3RBAN,3RDIT,61,3RCRO,2ROK,61,3RGEN,1RT,61,
	2 3RGEN,3RTLE,61,3RMAN,0,61,3RTHU,1RG,61,
	3 3RBAG,3RMAN,61,3RSTI,3RLLE,62/
C
	DATA OVOC4/3RWIN,3RDOW,63,3RBOL,1RT,64,3RNUT,0,64,
	1 3RGRA,2RTE,65,3RGRA,3RTIN,65,3RDOO,1RR,66,67,68,69,
	1 164,172,173,174,175,189,3RTRA,3RPDO,66,
	2 3RTRA,3RP$D,66,3RSWI,3RTCH,70,76,79,80,81,82,170,
	3 3RHEA,1RD,71,120,3RCOR,3RPSE,72,73,3RBOD,3RIES,73,
	4 3RDAM,0,74,3RGAT,2RES,74,76,3RGAT,1RE,74,76,
	5 3RFCD,0,74,3RRAI,1RL,75,3RRAI,3RLIN,75,
	5 3RBUT,3RTON,76,79,80,81,82,127,128,129,170,176,
	6 3RBUB,3RBLE,77,3RLEA,1RK,78,3RDRI,1RP,78,
	7 3RHOL,1RE,78,107,
	9 3RBAT,0,83,3RRAI,3RNBO,84,
	1 3RPOT,0,85,3RSTA,3RTUE,86,3RSCU,3RLPT,86,3RROC,1RK,86,
	2 3RBOA,1RT,87,88,90,3RPLA,3RSTI,87,88,
	3 3RPUM,1RP,89/
C
	DATA OVOC5/3RAIR,3RPUM,89,3RAIR,3R$PU,89,3RLAB,2REL,91,112,
	1 3RFIN,3REPR,91,3RSTI,2RCK,92,3RBAR,3RREL,93,3RBUO,1RY,94,
	2 3REME,3RRAL,95,3RSHO,3RVEL,96,3RGUA,2RNO,97,3RCRA,1RP,97,
	3 3RSHI,1RT,97,3RHUN,1RK,97,3RBAL,3RLOO,98,113,
	4 3RREC,3REPT,99,3RWIR,1RE,101,110,
	5 3RHOO,1RK,102,103,3RZOR,3RKMI,104,148,3RCOI,1RN,104,
	6 3RSAF,1RE,105,3RCAR,1RD,106,188,3RNOT,1RE,106,186,
	7 3RSLO,1RT,107,187,3RCRO,2RWN,108,3RBRI,2RCK,109,
	8 3RFUS,1RE,110,3RGNO,2RME,111,152,
	1 3RSTA,2RMP,118,
	2 3RTOM,1RB,119,3RCRY,2RPT,119,3RGRA,2RVE,119,3RHEA,2RDS,120,
	3 3RPOL,2RES,120,3RIMP,3RLEM,120/
C
	DATA OVOC6/3RLOS,3RERS,120,3RCOK,2RES,121,
	1 3RLIS,3RTIN,122,3RSTA,2RCK,122,
	2 3RPRI,3RNTO,122,
	3 3RSPH,3RERE,126,3RBAL,1RL,126,
	4 3RETC,3RHIN,130,131,
	5 3RWAL,2RLS,130,131,198,205,206,207,208,3RWAL,1RL,
	5 130,131,159,160,161,162,163,164,198,205,206,207,208,
	6 3RFLA,2RSK,132,3RPOO,1RL,133,3RSEW,3RAGE,133,
	7 3RTIN,0,134,3RSAF,3RFRO,134,3RSPI,3RCES,134,3RTAB,2RLE,135,
	8 3RPOS,1RT,136,166,167,3RPOS,2RTS,136,3RBUC,3RKET,137,
	9 3RCAK,1RE,138,139,140,141,3RICI,2RNG,139,140,141,
	1 3RROB,2ROT,142,3RROB,2RBY,142,
	2 3RC3P,1RO,142,3RR2D,1R2,142/
C
	DATA OVOC6A/3RPAN,2REL,159,160,161,162,163,164,213,
	1 3RPOL,1RE,166,167,3RTBA,1RR,168,3RT$B,2RAR,168,
	2 3RARR,2ROW,169,3RPOI,2RNT,169,3RBEA,1RM,171,
	3 3RDIA,1RL,177,3RSUN,3RDIA,177,1R1,0,178,
	4 3RONE,0,178,1R2,0,179,3RTWO,0,179,1R3,0,180,
	5 3RTHR,2REE,180,1R4,0,181,3RFOU,1RR,181,1R5,0,182,
	6 3RFIV,1RE,182,1R6,0,183,3RSIX,0,183,1R7,0,184,
	7 3RSEV,2REN,184,1R8,0,185,3REIG,2RHT,185,
	8 3RWAR,3RNIN,186,3RSLI,1RT,187,
	3 2RIT,0,192,3RTHA,1RT,192,3RTHI,1RS,192/
C
	DATA OVOC7/2RME,0,193,3RMYS,3RELF,193,3RCRE,3RTIN,193,
	1 3RALL,0,194,3REVE,3RRYT,194,
	1 3RTRE,3RASU,195,3RVAL,3RUAB,195,3RSAI,3RLOR,196,3RTEE,2RTH,197,
	2 3RGRU,1RE,199,3RHAN,1RD,200,3RHAN,2RDS,200,
	3 3RLUN,2RGS,201,3RAIR,0,201,3RAVI,3RATO,202,
	4 3RFLY,2RER,202,3RTRE,1RE,144,145,204,
	5 3RCLI,2RFF,146,147,3RLED,2RGE,146,147,3RPOR,3RTRA,149,
	6 3RSTA,2RCK,148,3RBIL,2RLS,148,
	6 3RVAU,2RLT,150,3RCUB,1RE,150,3RLET,3RTER,67,150,
	7 3RCUR,3RTAI,151,3RLIG,2RHT,151,3RNES,1RT,153,
	8 3REGG,0,154,155,3RBAU,3RBLE,156,3RCAN,3RARY,157,158,
	9 3RBIR,1RD,203,3RSON,3RGBI,203,
	1 3RGUA,2RRD,210,3RGUA,3RRDI,210,3RROS,1RE,211,
	2 3RSTR,3RUCT,212,3RCHA,3RNNE,214,
	3 3RKEE,3RPER,215,3RLAD,3RDER,216/
C
	DATA OVOCND/-1/
C SPARSE, PAGE 7
C
C SET UP FOR PARSING
C
	SPARSE=-1				!ASSUME PARSE FAILS.
	ADJ=0					!CLEAR PARTS HOLDERS.
	ACT=0
	PREP=0
	PPTR=0
	O1=0
	O2=0
	P1=0
	P2=0
D	DFLAG=(PRSFLG.AND."4).NE.0
C
	BUZLNT=20
	PRPLNT=48
	DIRLNT=75
C SPARSE, PAGE 8
C
C NOW LOOP OVER INPUT BUFFER OF LEXICAL TOKENS.
C
	DO 1000 I=1,LLNT,2			!TWO WORDS/TOKEN.
	  LBUF1=LBUF(I)				!GET CURRENT TOKEN.
	  LBUF2=LBUF(I+1)
	  IF(LBUF1.EQ.0) GO TO 1500		!END OF BUFFER?
C
C CHECK FOR BUZZ WORD
C
	  DO 50 J=1,BUZLNT,2
	    IF((LBUF1.EQ.BVOC(J)).AND.(LBUF2.EQ.BVOC(J+1)))
	1	GO TO 1000			!IGNORE BUZZ WORDS.
50	  CONTINUE
C
C CHECK FOR ACTION OR DIRECTION
C
	  IF(ACT.NE.0) GO TO 75			!GOT ACTION ALREADY?
	  J=1					!CHECK FOR ACTION.
125	  IF((LBUF1.EQ.VVOC(J)).AND.(LBUF2.EQ.VVOC(J+1)))
	1	GO TO 3000
150	  J=J+2					!ADV TO NEXT SYNONYM.
	  IF(.NOT.OTEST(VVOC(J))) GO TO 125	!ANOTHER VERB?
	  J=J+VVOC(J)+1				!NO, ADVANCE OVER SYNTAX.
	  IF(VVOC(J).NE.-1) GO TO 125		!TABLE DONE?
C
75	  IF((ACT.NE.0).AND.((VVOC(ACT).NE.R50WAL).OR.
	1	(PREP.NE.0))) GO TO 200		!NO ACTION OR WALK?
	  DO 100 J=1,DIRLNT,3			!THEN CHK FOR DIR.
	    IF((LBUF1.EQ.DVOC(J)).AND.(LBUF2.EQ.DVOC(J+1)))
	1	GO TO 2000
100	  CONTINUE
C
C NOT AN ACTION, CHECK FOR PREPOSITION, ADJECTIVE, OR OBJECT.
C
200	  DO 250 J=1,PRPLNT,3			!LOOK FOR PREPOSITION.
	    IF((LBUF1.EQ.PVOC(J)).AND.(LBUF2.EQ.PVOC(J+1)))
	1	GO TO 4000
250	  CONTINUE
C
	  J=1					!LOOK FOR ADJECTIVE.
300	  IF((LBUF1.EQ.AVOC(J)).AND.(LBUF2.EQ.AVOC(J+1)))
	1	GO TO 5000
	  J=J+1
325	  J=J+1					!ADVANCE TO NEXT ENTRY.
	  IF(OTEST(AVOC(J))) GO TO 325	!A RADIX 50 CONSTANT?
	  IF(AVOC(J).NE.-1) GO TO 300		!POSSIBLY, END TABLE?
C
	  J=1					!LOOK FOR OBJECT.
450	  IF((LBUF1.EQ.OVOC(J)).AND.(LBUF2.EQ.OVOC(J+1)))
	1	GO TO 600
	  J=J+1
500	  J=J+1
	  IF(OTEST(OVOC(J))) GO TO 500
	  IF(OVOC(J).NE.-1) GO TO 450
C
C NOT RECOGNIZABLE
C
	  IF(VBFLAG) CALL RSPEAK(601)
	  RETURN
C SPARSE, PAGE 9
C
C OBJECT PROCESSING (CONTINUATION OF DO LOOP ON PREV PAGE)
C
600	  OBJ=GETOBJ(J,ADJ,0)			!IDENTIFY OBJECT.
D	  IF(DFLAG) TYPE 60,J,OBJ
D60	  FORMAT(' SPARSE- OBJ AT ',I6,'  OBJ= ',I6)
	  IF(OBJ.LE.0) GO TO 6000		!IF LE, COULDNT.
	  IF(OBJ.NE.ITOBJ) GO TO 650		!"IT"?
	  OBJ=GETOBJ(0,0,LASTIT)		!FIND LAST.
	  IF(OBJ.LE.0) GO TO 6000		!IF LE, COULDNT.
C
650	  IF(PREP.EQ.9) GO TO 8000		!"OF" OBJ?
	  IF(PPTR.EQ.2) GO TO 7000		!TOO MANY OBJS?
	  PPTR=PPTR+1
	  OBJVEC(PPTR)=OBJ			!STUFF INTO VECTOR.
	  PRPVEC(PPTR)=PREP
700	  PREP=0
	  ADJ=0
1000	CONTINUE				!AT LAST.
C
C NOW SOME MISC CLEANUP
C
1500	IF(ACT.EQ.0) ACT=OFLAG.AND.OACT	!IF NO ACT, STEAL ORPHAN.
	IF(ACT.EQ.0) GO TO 9000			!IF STILL NONE, PUNT.
	IF(ADJ.NE.0) GO TO 10000		!IF DANGLING ADJ, PUNT.
C
	IF((OFLAG.NE.0).AND.(OPREP.NE.0).AND.(PREP.EQ.0).AND.
	1	(O1.NE.0).AND.(O2.EQ.0).AND.(ACT.EQ.OACT))
	2	GO TO 11000
C
	SPARSE=0				!PARSE SUCCEEDS.
	IF(PREP.EQ.0) GO TO 1750		!IF DANGLING PREP,
	IF((PPTR.EQ.0).OR.(PRPVEC(PPTR).NE.0))
	1	GO TO 12000			!AND HAVE 'PICK FROB UP',
	PRPVEC(PPTR)=PREP			!CVT TO 'PICK UP FROB'.
1750	CONTINUE				!WIN.
D	IF(DFLAG) TYPE 70,ACT,O1,O2,P1,P2
D70	FORMAT(' SPARSE RESULTS- ',5I7)
	RETURN
C SPARSE, PAGE 10
C
C SPECIAL PARSE PROCESSORS
C
C 2000--	DIRECTION
C
2000	PRSA=WALKW				!VERB IS WALK.
	PRSO=DVOC(J+2)				!GET DIRECTION.
	SPARSE=1				!WIN TOTALLY.
D	IF(DFLAG) TYPE 10,J
D10	FORMAT(' SPARSE- DIR AT ',I6)
	RETURN
C
C 3000--	ACTION
C
3000	ACT=J					!SAVE INDEX TO VERB.
	OACT=0					!NO ORPHAN.
D	IF(DFLAG) TYPE 20,J
D20	FORMAT(' SPARSE- ACT AT ',I6)
	GO TO 1000				!DONE.
C
C 4000--	PREPOSITION
C
4000	IF(PREP.NE.0) GO TO 4500		!ALREADY HAVE ONE?
	PREP=PVOC(J+2)			!NO, GET INDEX.
	ADJ=0					!NO ADJECTIVE.
D	IF(DFLAG) TYPE 30,J
D30	FORMAT(' SPARSE- PREP AT ',I6)
	GO TO 1000
C
4500	IF(VBFLAG) CALL RSPEAK(616)		!YES, GAG AND LOSE.
	RETURN
C
C 5000--	ADJECTIVE
C
5000	ADJ=J					!SAVE ADJECTIVE.
	J=ONAME.AND.OFLAG
D	IF(DFLAG) TYPE 40,ADJ,J
D40	FORMAT(' SPARSE- ADJ AT ',I6,' ORPHAN= ',I6)
	IF((J.NE.0).AND.(I.GE.LLNT)) GO TO 600
	GO TO 1000
C
C 6000--	UNIDENTIFIABLE OBJECT (INDEX INTO OVOC IS J)
C
6000	IF(OBJ.LT.0) GO TO 6100			!IF LT, AMBIGUOUS.
	I=579					!NOT HERE OR
	IF(LIT(HERE)) I=618			!NOT LIT.
	IF(VBFLAG) CALL RSPEAK(I)
	RETURN					!LOSE.
C
6100	IF(OBJ.NE.-10000) GO TO 6200		!INSIDE VEHICLE?
	IF(VBFLAG) CALL RSPSUB(620,ODESC2(AVEHIC(WINNER)))
	RETURN
C
6200	IF(VBFLAG) CALL RSPEAK(619)		!CANT DISTINGUISH.
	IF(ACT.EQ.0) ACT=OFLAG.AND.OACT	!IF NO ACT, GET ORPHAN.
	CALL ORPHAN(-1,ACT,O1,PREP,J)		!ORPHAN THE WORLD.
	RETURN
C
C 7000--	TOO MANY OBJECTS.
C
7000	IF(VBFLAG) CALL RSPEAK(617)
	RETURN
C
C 8000--	RANDOMNESS FOR "OF" WORDS
C
8000	IF(OBJVEC(PPTR).EQ.OBJ) GO TO 700	!IGNORE IF OK.
	IF(VBFLAG) CALL RSPEAK(601)
	RETURN
C
C 9000--	NO ACTION, PUNT
C
9000	IF(O1.EQ.0) GO TO 10000			!ANY DIRECT OBJECT?
	IF(VBFLAG) CALL RSPSUB(621,ODESC2(O1))	!WHAT TO DO?
	CALL ORPHAN(-1,0,O1,0,0)
	RETURN
C
C 10000--	TOTAL CHOMP
C
10000	IF(VBFLAG) CALL RSPEAK(622)		!HUH?
	RETURN
C
C 11000--	ORPHAN PREPOSITION.  CONDITIONS ARE
C		O1.NE.0, O2=0, PREP=0, ACT=OACT
C
11000	IF(OSLOT.NE.0) GO TO 11500		!ORPHAN OBJECT?
	P1=OPREP				!NO, JUST USE PREP.
	GO TO 1750
C
11500	O2=O1					!YES, USE AS DIRECT OBJ.
	P2=OPREP
	O1=OSLOT
	P1=0
	GO TO 1750
C
C 12000--	TRUE HANGING PREPOSITION.
C		ORPHAN FOR LATER.
C
12000	CALL ORPHAN(-1,ACT,0,PREP,0)		!ORPHAN PREP.
	GO TO 1750
C
	END
